ORCA/M Asm65816 2.1.0

0001 C2D7              **********************************************************************
0002 C2D7              *
0003 C2D7              * File:  StartStop.asm
0004 C2D7              *
0005 C2D7              * Copyright Apple Computer, Inc. 1988-92
0006 C2D7              * All Rights Reserved
0007 C2D7              *
0008 C2D7              * by Dan Oliver & Steven Glass
0009 C2D7              *
0010 C2D7              * This file has two entry points:
0011 C2D7              *
0012 C2D7              *    StartupTools
0013 C2D7              *    ShutDownTools
0014 C2D7              *
0015 C2D7              * Change History
0016 C2D7              *
0017 C2D7              * 02 Nov 88         Dan Oliver
0018 C2D7              *
0019 C2D7              * Coding began.
0020 C2D7              *
0021 C2D7              * 08 Nov 88         Steven Glass
0022 C2D7              *
0023 C2D7              * Integrated with tool locator.  Changed order of tool loading and
0024 C2D7              * shutdown.
0025 C2D7              *
0026 C2D7              * Fixed bug for FontManager direct page allocation and startup.
0027 C2D7              *
0028 C2D7              * 09 Nov 88         Steven Glass
0029 C2D7              *
0030 C2D7              * Changed StartStop record to include flags word and dPage handle.
0031 C2D7              * Flags word can be used later to indicate whether application wants 
0032 C2D7              * certain things. (Currently no flags defined.)
0033 C2D7              *
0034 C2D7              * DPage hanndle is saved in startstop record at startup so it can
0035 C2D7              * be disposed at shutdown.
0036 C2D7              *
0037 C2D7              * Wrote central disposing routine: KillIt to dispose handles.
0038 C2D7              *
0039 C2D7              * Returned result of startstop to calling routine by always 
0040 C2D7              * copying the handle to result before exit.  This meant 
0041 C2D7              * that in the pointer case, I had to put the pointer into
0042 C2D7              * the handle to begin with.
0043 C2D7              *
0044 C2D7              * If the shutdown call is called with a handle, we dispose
0045 C2D7              * of it.
0046 C2D7              *
0047 C2D7              * 09 Dec 88         Mensch
0048 C2D7              *
0049 C2D7              * Added support for Note Synth, Note sequencer, MIDI, and ACE
0050 C2D7              * Modified addPages routine so that it allocates the proper amount of
0051 C2D7              * dpage space when the note seq and sound tools are both started up. 
0052 C2D7              * Also, the sound tools startup routine had to be modified to not be  
0053 C2D7              * called when the user wants to use the note seq.
0054 C2D7              *
0055 C2D7              * Modified Note synth shutdown and sound tools shutdown so that errors 
0056 C2D7              * are ignored. This is so that if you started them up with the noteseq
0057 C2D7              * the shutdown routine will be able to shut everything down.
0058 C2D7              *
0059 C2D7              *  01/25/89         Dan - Corrected some comments.
0060 C2D7              *
0061 C2D7              * 06 Feb 89         Steven Glass
0062 C2D7              *
0063 C2D7              * Added TL to shutdown table.
0064 C2D7              *
0065 C2D7              * 06 Feb 89         Harry Yee
0066 C2D7              *
0067 C2D7              * Fixed problem in StartTools call. If an error is encountered in starting up
0068 C2D7              * one of the toolsets the stack is not cleaned up correctly. The tool number
0069 C2D7              * is still left on the stack. If an error returns from @StartupTools then an
0070 C2D7              * extra word is pulled off the stack before branching to @errout2.
0071 C2D7              *
0072 C2D7              * 10 Feb 89         Harry Yee
0073 C2D7              *
0074 C2D7              * In StartTools, we now set the OS global system preferences so that under 
0075 C2D7              * certain circumstances, the system's Mount facility will be called to display
0076 C2D7              * a dialog asking the user to mount a specified volume. BRC #41150.
0077 C2D7              *
0078 C2D7              * 17 Feb 89         Dave Good
0079 C2D7              *
0080 C2D7              * In the start/stop record there a word for the video mode which is passed to
0081 C2D7              * qdstartup and used to determine the mouse clamps for the event manager. The
0082 C2D7              * problem is that there is a new feature in QuickDraw that allows an application
0083 C2D7              * to tell quickdraw to use shadowed memory and this feature uses the high bit
0084 C2D7              * of the video mode. I presume that we want the video mode in the start/stop
0085 C2D7              * record to be used the same way, so I masked it with $00FF in the emStartup
0086 C2D7              * code.
0087 C2D7              *
0088 C2D7              * 22 Feb 89         Steven Glass
0089 C2D7              *
0090 C2D7              * Changed call to OpenResourceFile to use new inputs.
0091 C2D7              *
0092 C2D7              * 03 Mar 89         Dan O
0093 C2D7              *
0094 C2D7              * Switched to arrow cursor before leaving StartupTools.  If QDAux was 
0095 C2D7              * started the watch cursor was being left.
0096 C2D7              *
0097 C2D7              * 14 Mar 89         Steven Glass
0098 C2D7              *
0099 C2D7              * Undid dan's fix above.
0100 C2D7              *
0101 C2D7              * 30 Mar 89         Steven Glass
0102 C2D7              *
0103 C2D7              * Make scrambler safe.  The handle to the start stop record is now
0104 C2D7              * locked before it is used.  It is unlocked just before it is 
0105 C2D7              * returned.
0106 C2D7              *
0107 C2D7              * 11 Apr 89         Steven Glass
0108 C2D7              *
0109 C2D7              * Changed tool number for misc tools.  Was listed as 2, its really 3.
0110 C2D7              *
0111 C2D7              * Made it handle all tools except 13.  Any tool not in list is assumed to have
0112 C2D7              * no startup and no direct page needs.
0113 C2D7              *
0114 C2D7              **********************************************************************
0115 C2D7
0116 C2D7                       Blanks off                     ;No white space in the operand field.
0117 C2D7
0118 C2D7                       INCLUDE 'all.macros' 
0119 C2D7                       include 'e16.memory' 
0120 C2D7
0121 C2D7
0122 C2D7              **********************************************************************
0123 C2D7              *
0124 C2D7              *   Startup - Shutdown tool equates.
0125 C2D7              *
0126 C2D7              **********************************************************************
0127 C2D7
0128 C2D7
0129 C2D7              StartStopRecord Record 0 
0130 C2D7              Flags    ds.w 1 Flags for starting and stopping
0131 C2D7              VideoMode ds.w 1 SCB byte of mode to startup in.
0132 C2D7              ResFileID ds.w 1  Return file ID of app's res file, NIL = none.
0133 C2D7              DPageHandle ds.L 1 holds handle allocated for dpage
0134 C2D7
0135 C2D7              NumTools ds.w 1   Number of tools to load.
0136 C2D7              ToolArray ds.w 2 Array of tools to load, elements defined as:
0137 C2D7              ;                                            WORD - tool number.
0138 C2D7              ;                                            WORD - minimum version number.
0139 C2D7
0140 C2D7                       ENDR 
0141 C2D7
0142 C2D7              ;
0143 C2D7              ; --- Direct page offsets.
0144 C2D7              ;
0145 C2D7              loading  equ   1                        TRUE if loading tools.
0146 C2D7              loadTable equ   loading+2               Load tool hash table, enough for 48 tools.
0147 C2D7              directPages equ   loadTable+6
0148 C2D7              numPages equ   directPages+4
0149 C2D7              getNameBlk equ   numPages+2
0150 C2D7              getName  equ   getNameBlk+2
0151 C2D7              handle   equ   getName+4
0152 C2D7              ptr      equ   handle+4
0153 C2D7              UtilFlags equ   ptr+4
0154 C2D7              saveDbank equ   UtilFlags+4             Flags for use with sound tool startup (used Bits 0-3)
0155 C2D7              saveDpage equ   saveDbank+1
0156 C2D7              retAddr  equ   saveDpage+2
0157 C2D7              startRec equ   retAddr+6
0158 C2D7              startRecFlag equ   startRec+4
0159 C2D7              userID   equ   startRecFlag+2
0160 C2D7              result   equ   userID+2
0161 C2D7
0162 C2D7              skipResMgr equ   $10                    ;bit 4 for StartUpTools/ShutDownTools: skip RM & pre-allocation
0163 C2D7
0164 C2D7              ;
0165 C2D7              ; --- Tool error codes.
0166 C2D7              ;
0167 C2D7              TLBadRecFlag equ   $0103                Invalid startup record flag passed.
0168 C2D7              TLCantLoad equ   $0104                  Cant load a tool.
0169 C2D7              ;
0170 C2D7              ;
0171 C2D7              ; --- Tool startup resource equates.
0172 C2D7              ;
0173 C2D7              rToolStartup equ   $8013                Resource type of tool startup record.
0174 C2D7              ;
0175 C2D7              ;
0176 C2D7              ; --- UtilFlags codes.
0177 C2D7              WantsSound equ   $0001                  indicates sound tools desired
0178 C2D7              WantsSynth equ   $0002                  indicates Note Synth desired
0179 C2D7              WantsSeq equ   $0004                    indicates wants note seuqencer started
0180 C2D7              WantsMIDI equ   $0008                   indicates wants MIDI started
0181 C2D7              ;
0182 C2D7              ; --- Tool set numbers used
0183 C2D7              ;
0184 C2D7              SoundToolSet equ   8
0185 C2D7              NoteSynth equ   25
0186 C2D7              NoteSeq  equ   26
0187 C2D7              MIDITools equ   32
0188 C2D7              ; --- System equates.
0189 C2D7              ;
0190 C2D7              IncBusyFlg equ   $E10064
0191 C2D7              DecBusyFlg equ   $E10068
0192 C2D7
0193 C2D7              Stack_Entry equ   $E100B0
0194 C2D7
0195 C2D7
0196 C2D7              ****************************************************************
0197 C2D7              *
0198 C2D7              StartupTools PROC EXPORT 
0199 C2D7              *
0200 C2D7              * Description
0201 C2D7              *
0202 C2D7              *
0203 C2D7              *   IN: 
0204 C2D7              *     PUSH:LONG - space for result.
0205 C2D7              *     PUSH:WORD - User ID.
0206 C2D7              *     PUSH:WORD - 0 if startup record is a pointer, 4 if a resource ID.
0207 C2D7              *     PUSH:LONG - pointer or resource ID of startup record.
0208 C2D7              *
0209 C2D7              *  OUT: 
0210 C2D7              *     PULL:LONG - handle of startup record if a resource ID was passed, 
0211 C2D7              *                   else pointer to record.
0212 C2D7              *
0213 C2D7              * External Refs:
0214 C2D7                       IMPORT startCall 
0215 C2D7                       IMPORT openAppRes 
0216 C2D7                       IMPORT getStartupPtr 
0217 C2D7                       IMPORT walkToolArray 
0218 C2D7                       IMPORT pop 
0219 C2D7                       import KillIt 
0220 C2D7              *
0221 C2D7              * Entry Points:
0222 C2D7              *                   none
0223 C2D7              *
0224 C2D7                       longa on                       ; mode
0225 C2D7                       longi on
0226 C2D7              *
0227 C2D7              ****************************************************************
0228 C2D7
0229 C2D7 20 37 C6              jsr   startCall                Allocate a direct page.
0230 C2DA
0231 C2DA              ;
0232 C2DA              ; Set the global system preferences so that under certain circumstances the
0233 C2DA              ; system's Mount facility will be called asking the user to mount a specified volume
0234 C2DA              ;
0235 C2DA
0236 C2DA              ; First save the current System Preferences
0237 C2DA
0238 C2DA F4 00 00              pea   0                        Set up paramBlock for call
0239 C2DD F4 01 00              pea   1
0240 C2E0 3B                    tsc                            calculate address to paramblock
0241 C2E1 1A                    inc   a                        and push on stack
0242 C2E2 F4 00 00              pea   0
0243 C2E5 48                    pha   
0244 C2E6 F4 0F 20              pea   $200F                    Get_Sys_Prefs
0245 C2E9 22 B0 00 E1           jsl   Stack_Entry              Leave parameter block on the stack so we can restore later
0246 C2ED
0247 C2ED              ; Now set the System preferences to display volume mount dialog w/o the cancel button
0248 C2ED
0249 C2ED F4 00 C0              pea   $C000                    system preferences
0250 C2F0 F4 01 00              pea   1                        pcount
0251 C2F3 3B                    tsc                            calculate address to paramblock
0252 C2F4 1A                    inc   a                        and push on stack
0253 C2F5 F4 00 00              pea   0
0254 C2F8 48                    pha   
0255 C2F9 F4 0C 20              pea   $200C                    Set_Sys_Prefs
0256 C2FC 22 B0 00 E1           jsl   Stack_Entry
0257 C300 68                    pla                            Get Parameter block off the stack.
0258 C301 68                    pla   
0259 C302              ;
0260 C302              ;
0261 C302              ; --- Open application's resource file.
0262 C302              ;
0263 C302 20 64 C6              jsr   openAppRes               Open application's resource file.
0264 C305
0265 C305 48                    pha                            Save open resource file ID.
0266 C306 20 E3 C5              jsr   getStartupPtr            Get startup record pointer.
0267 C309 68                    pla   
0268 C30A 90 03                 bcc   @ok1                     Error?  Y = error code.
0269 C30C 82 C2 00     @toErrOut brl   @errOut
0270 C30F
0271 C30F A0 04 00     @ok1     ldy   #StartStopRecord.ResFileID Return file ID of app's open resource file.
0272 C312 97 2A                 sta   [<startRec],y
0273 C314              ;
0274 C314              ;
0275 C314              ; --- Allocate direct pages for tools.
0276 C314              ;
0277 C314 64 0D                 stz   <numPages                Start with no pages.
0278 C316 64 1D                 stz   <UtilFlags               zero out the flags
0279 C318              ;
0280 C318 A9 29 C4              lda   #addPages                Compute number of direct pages needed.
0281 C31B 20 EE C6              jsr   walkToolArray
0282 C31E              ;
0283 C31E A5 0D                 lda   <numPages                Any direct pages needed?
0284 C320 F0 2C                 beq   @skip1
0285 C322              ;
0286 C322 A9 00 00              lda   #0                       Common need.
0287 C325 48                    pha                            Space for result.
0288 C326 48                    pha   
0289 C327 48                    pha                            Pass number of bytes to allocate.
0290 C328 D4 0D                 pei   <numPages
0291 C32A D4 30                 pei   <userID                  Pass my user ID.
0292 C32C F4 05 C0              pea   $C005                    Pass attributes; locked, fixed bank, page aligned.
0293 C32F 48                    pha                            Pass address, bank zero.
0294 C330 48                    pha   
0295 C331 A2 02 09 22           _NewHandle 
0296 C338 A8                    tay                            Possible error code.
0297 C339 68                    pla   
0298 C33A 85 09                 sta   <directPages
0299 C33C 68                    pla   
0300 C33D 85 0B                 sta   <directPages+2
0301 C33F B0 CB                 bcs   @toErrOut
0302 C341
0303 C341              ;-----------------------------------------------------------
0304 C341              ;
0305 C341              ; Put direct page handle into the startstop record.
0306 C341              ;
0307 C341
0308 C341 A0 06 00              ldy   #StartStopRecord.DPageHandle
0309 C344 A5 09                 lda   directPages
0310 C346 97 2A                 sta   [StartRec],y
0311 C348 C8                    iny   
0312 C349 C8                    iny   
0313 C34A A5 0B                 lda   directPages+2
0314 C34C 97 2A                 sta   [StartRec],y
0315 C34E
0316 C34E
0317 C34E              ;
0318 C34E              ;
0319 C34E              ; --- Load and start tools requested by caller.
0320 C34E              ;
0321 C34E              @skip1    
0322 C34E 64 03                 stz   <loadTable               Clear tool load table.
0323 C350 64 05                 stz   <loadTable+2
0324 C352 64 07                 stz   <loadTable+4
0325 C354              ;
0326 C354 64 01                 stz   <loading                 TRUE for loading tools.
0327 C356 E6 01                 inc   <loading
0328 C358              ;
0329 C358
0330 C358 A9 00 00              lda   #0
0331 C35B 48                    pha   
0332 C35C 48                    pha   
0333 C35D F4 00 00 F4           PushLong #$00008000 
0334 C363 F4 01 40              PushWord #$4001                ; tool locator's user id
0335 C366 F4 02 00              PushWord #attrAddr 
0336 C369 F4 E1 00 F4           PushLong #$00E12000 
0337 C36F A2 02 09 22           _NewHandle 
0338 C376              @skipPreallocate  
0339 C376
0340 C376 A9 A5 C4              lda   #buildLoadTable          Build hash table of tools to load.
0341 C379 20 EE C6              jsr   walkToolArray
0342 C37C
0343 C37C 68                    pla                            Get handle to screen into
0344 C37D FA                    plx                            a & X
0345 C37E
0346 C37E 08                    php                            Save error status
0347 C37F 5A                    phy                            Save error code
0348 C380
0349 C380 20 CC C8              jsr   KillIt
0350 C383
0351 C383 7A                    ply                            Restore error code and
0352 C384 28                    plp                            status register
0353 C385
0354 C385 90 0D                 bcc   @ok2                     Error loading tools?
0355 C387              ;
0356 C387 98                    tya   
0357 C388 48           @errOut2 pha                            Save error code.
0358 C389 A6 0B                 ldx   <directPages+2           Free allocated direct pages.
0359 C38B A5 09                 lda   <directPages
0360 C38D 20 CC C8              jsr   KillIt
0361 C390 7A                    ply                            Restore error code.
0362 C391 82 3D 00              brl   @errOut
0363 C394              ;
0364 C394 64 0D        @ok2     stz   <numPages                Start with first page.
0365 C396              ;
0366 C396              ; --- Startup loop.
0367 C396              ;
0368 C396 A2 00 00              ldx   #0
0369 C399 80 15                 bra   @enter1
0370 C39B DA           @lop1    phx   
0371 C39C
0372 C39C 20 EE C4              jsr   checkLoadTable           Check if user wants this tool started.
0373 C39F F0 0B                 beq   @next1
0374 C3A1
0375 C3A1 A3 01                 lda   1,s                       Call startup handler.
0376 C3A3 AA                    tax   
0377 C3A4 FC E7 C3              jsr   (@startupTable+1,x)
0378 C3A7 90 03                 bcc   @next1                   No error?
0379 C3A9 FA                    plx                            Error, so clean up stack and beat it.
0380 C3AA 80 DC                 bra   @errOut2
0381 C3AC
0382 C3AC FA           @next1   plx                            Next tool.
0383 C3AD E8                    inx   
0384 C3AE E8                    inx   
0385 C3AF E8                    inx   
0386 C3B0 BD E6 C3     @enter1  lda   |@startupTable,x         Next tool to start.
0387 C3B3 29 FF 00              and   #$00FF
0388 C3B6 D0 E3                 bne   @lop1                    Any more tools?
0389 C3B8
0390 C3B8
0391 C3B8
0392 C3B8              ;-----------------------------------------------------------
0393 C3B8              ;
0394 C3B8              ; Return the result to the calling routine.
0395 C3B8              ;
0396 C3B8 A5 15                 lda   handle
0397 C3BA 85 32                 sta   Result
0398 C3BC A5 17                 lda   handle+2
0399 C3BE 85 34                 sta   Result+2
0400 C3C0
0401 C3C0              ;-----------------------------------------------------------
0402 C3C0              ;
0403 C3C0              ; Unlock if input was handle or resource
0404 C3C0              ;
0405 C3C0              ;
0406 C3C0 A5 2E                 lda   StartRecFlag
0407 C3C2 F0 0A                 beq   @IsPtr
0408 C3C4 A0 04 00              ldy   #4
0409 C3C7 B7 15                 lda   [<handle],y
0410 C3C9 29 FF 7F              and   #$7FFF
0411 C3CC 97 15                 sta   [<handle],y
0412 C3CE              @IsPtr    
0413 C3CE
0414 C3CE A0 00 00              ldy   #0                       No error.
0415 C3D1
0416 C3D1 3B           @errOut  tsc                            Parameter block for Set_Sys_Prefs still on stack
0417 C3D2 1A                    inc   a
0418 C3D3 F4 00 00              pea   0000
0419 C3D6 48                    pha   
0420 C3D7 F4 0C 20              pea   $200C
0421 C3DA 22 B0 00 E1           jsl   Stack_Entry
0422 C3DE FA                    plx                            Get parameter block off the stack.
0423 C3DF FA                    plx   
0424 C3E0              ;
0425 C3E0              ; --- Exit.
0426 C3E0              ;
0427 C3E0              ;  y = error code.
0428 C3E0              ;
0429 C3E0 A2 08 00              ldx   #8                       Number of bytes to strip.
0430 C3E3 82 8F 01              brl   pop
0431 C3E6
0432 C3E6
0433 C3E6              **********************************************************************
0434 C3E6              *
0435 C3E6              * This is the startup table.  To add a tool to be started up add
0436 C3E6              * a record to this table at the position you want it to be started.
0437 C3E6              * The first tool started is the first tool in the table.
0438 C3E6              * A record is a one byte tool number followed by a one word
0439 C3E6              * address of a routine that starts the tool.  The routine should 
0440 C3E6              * start the tool and return carry set if there is an error with
0441 C3E6              * an error code in a.
0442 C3E6              *
0443 C3E6              **********************************************************************
0444 C3E6                       IMPORT startMiscTools 
0445 C3E6                       IMPORT startQuickDraw 
0446 C3E6                       IMPORT startQDAux 
0447 C3E6                       IMPORT startEventMgr 
0448 C3E6                       IMPORT startWindowMgr 
0449 C3E6                       IMPORT startControlMgr 
0450 C3E6                       IMPORT startMenuMgr 
0451 C3E6                       IMPORT startDialog 
0452 C3E6                       IMPORT startLineEdit 
0453 C3E6                       IMPORT startStandardFile 
0454 C3E6                       IMPORT startDeskMgr 
0455 C3E6                       IMPORT startScrap 
0456 C3E6                       IMPORT startSound 
0457 C3E6                       IMPORT startSANE 
0458 C3E6                       IMPORT startPrintMgr 
0459 C3E6                       IMPORT startFont 
0460 C3E6                       IMPORT startTextEdit 
0461 C3E6                       IMPORT startNoteSynth 
0462 C3E6                       IMPORT StartNoteSeq 
0463 C3E6                       IMPORT startMIDI 
0464 C3E6                       IMPORT startACE 
0465 C3E6                       import startPokey 
0466 C3E6
0467 C3E6 03           @startupTable DC B:3
0468 C3E7 2A C7                 DC W:startMiscTools
0469 C3E9 04                    DC B:4
0470 C3EA 32 C7                 DC W:startQuickDraw
0471 C3EC 12                    DC B:18
0472 C3ED 54 C7                 DC W:startQDAux
0473 C3EF 06                    DC B:6
0474 C3F0 63 C7                 DC W:startEventMgr
0475 C3F2 0E                    DC B:14
0476 C3F3 90 C7                 DC W:startWindowMgr
0477 C3F5 10                    DC B:16
0478 C3F6 A9 C7                 DC W:startControlMgr
0479 C3F8 0F                    DC B:15
0480 C3F9 B9 C7                 DC W:startMenuMgr
0481 C3FB 14                    DC B:20
0482 C3FC D3 C7                 DC W:startLineEdit
0483 C3FE 15                    DC B:21
0484 C3FF C9 C7                 DC W:startDialog
0485 C401 16                    DC B:22
0486 C402 FB C7                 DC W:startScrap
0487 C404 17                    DC B:23
0488 C405 E3 C7                 DC W:startStandardFile
0489 C407 1B                    DC B:27
0490 C408 AC C8                 DC W:startFont
0491 C40A 13                    DC B:19
0492 C40B 9C C8                 DC W:startPrintMgr
0493 C40D 22                    DC B:34
0494 C40E BC C8                 DC W:startTextEdit
0495 C410 08                    DC B:8
0496 C411 03 C8                 DC W:startSound
0497 C413 19                    DC B:NoteSynth
0498 C414 18 C8                 DC W:startNoteSynth
0499 C416 1A                    DC B:NoteSeq
0500 C417 50 C8                 DC W:StartNoteSeq
0501 C419 20                    DC B:MIDITools
0502 C41A 40 C8                 DC W:StartMIDI
0503 C41C 1D                    DC B:29
0504 C41D 78 C8                 DC W:startACE
0505 C41F 0A                    DC B:10
0506 C420 86 C8                 DC W:startSANE
0507 C422 21                    DC B:33
0508 C423 94 C8                 DC W:startPokey
0509 C425 05                    DC B:5
0510 C426 F3 C7                 DC W:startDeskMgr
0511 C428 00                    DC B:0                         ;No more tools.
0512 C429
0513 C429
0514 C429              ;-----------------------------------------------------
0515 C429              ;   Compute number of direct pages needed.
0516 C429              ;-----------------------------------------------------
0517 C429              ;
0518 C429              ;   IN: y = index to tool in startup record.
0519 C429              ;   a = tool number.
0520 C429              ;   <numPages = current number of direct pages needed.
0521 C429              ;
0522 C429 C9 23 00     addPages cmp   #endTools-toolTable      Tool number in range?
0523 C42C B0 46                 bcs   @exit
0524 C42E A8                    tay                            place the tool number in <Y>
0525 C42F              ;
0526 C42F              ; First test to see if this is one of the sound tools
0527 C42F A2 00 00              ldx   #0                       use <X> as a temp flag
0528 C432 C9 08 00              cmp   #SoundToolSet            is this the sound tools?
0529 C435 D0 05                 bne   @AP0010                  if not test for note synth
0530 C437 A9 01 00              lda   #WantsSound              load the proper flag
0531 C43A 80 1E                 bra   @SetFlag                 and set it
0532 C43C
0533 C43C C9 19 00     @AP0010  cmp   #NoteSynth               is it the Note synthesizer?
0534 C43F D0 05                 bne   @AP0020                  if not test for MIDI
0535 C441 A9 02 00              lda   #WantsSynth              load the proper flag
0536 C444 80 14                 bra   @SetFlag                 and set it
0537 C446
0538 C446 C9 20 00     @AP0020  cmp   #MIDITools               is it the MIDI Tools?
0539 C449 D0 06                 bne   @AP0030                  if not test for Note Sequencer
0540 C44B A9 08 00              lda   #WantsMIDI
0541 C44E AA                    tax                            set <X> flag to be true
0542 C44F 80 09                 bra   @SetFlag
0543 C451
0544 C451 C9 1A 00     @AP0030  cmp   #NoteSeq                 is it the note sequencer?
0545 C454 D0 12                 bne   @DoAdd                   if not, just add in the proper value
0546 C456 A9 04 00              lda   #WantsSeq                load the proper flag
0547 C459 AA                    tax                            and set our <X>flag to be true
0548 C45A
0549 C45A              ; The SetFlag routine sets the proper flag in the UtilFlags word for the tool
0550 C45A              ; and then checks to see if the Note sequencer has already been added, If so, 
0551 C45A              ; we will skip adding more direct page space for the tools.
0552 C45A 05 1D        @SetFlag ora   <UtilFlags               set the flag
0553 C45C 85 1D                 sta   <UtilFlags
0554 C45E E0 00 00              cpx   #00                      test <X> for zero
0555 C461 D0 13                 bne   @AddSeq                  if its non-zero we are adding the sequencer or MIDI
0556 C463 29 04 00              and   #WantsSeq                next test if they already added sequencer direct page
0557 C466 D0 0C                 bne   @Exit                    if so, then we no longer need to add direct page
0558 C468
0559 C468              ; Now add the standard direct page value
0560 C468 B9 82 C4     @DoAdd   lda   |toolTable,y             Get pages this tool needs.
0561 C46B 29 7F 00              and   #$007F
0562 C46E EB                    xba   
0563 C46F 18                    clc   
0564 C470 65 0D                 adc   <numPages                Increment total pages needed.
0565 C472 85 0D                 sta   <numPages
0566 C474              ;
0567 C474 18           @exit    clc                            Continue flag.
0568 C475 60                    rts   
0569 C476              ; Add the sequencer direct page, but first test to see if the other tools have
0570 C476              ; already been added.
0571 C476 A5 1D        @AddSeq  lda   <UtilFlags               get the flags
0572 C478 AA                    tax                            save it for later
0573 C479 29 01 00              and   #WantsSound              test to see if sound already added in
0574 C47C D0 02                 bne   @AS0010                  if not the test for MIDI
0575 C47E C6 0C                 dec   <numPages-1              decrement the number of pages by 1
0576 C480 80 E6        @AS0010  bra   @DoAdd                   if not, go ahead and add the proper number of pages
0577 C482
0578 C482              canLoad  equ   $0080                    TRUE if I can load this tool.
0579 C482
0580 C482                       ENTRY toolTable 
0581 C482 00           toolTable DC B:0                        0 - not used.
0582 C483 80                    DC B:canLoad+0                 1 - Tool Locator, startup not needed.
0583 C484 80                    DC B:canLoad+0                 2 - Memory Manager, started by application.
0584 C485 80                    DC B:canLoad+0                 3 - Misc. Tool set.
0585 C486 83                    DC B:canLoad+3                 4 - QuickDraw II.
0586 C487 80                    DC B:canLoad+0                 5 - Desk Manager.
0587 C488 81                    DC B:canLoad+1                 6 - Event Manger.
0588 C489 80                    DC B:canLoad+0                 7 - Scheduler, startup not needed.
0589 C48A 81                    DC B:canLoad+1                 8 - Sound tool set.
0590 C48B 80                    DC B:canLoad+0                 9 - Apple Desktop Bus Tool set, startup not needed.
0591 C48C 81                    DC B:canLoad+1                 10 - SANE
0592 C48D 80                    DC B:canLoad+0                 11 - Integer Math tool set, startup not needed.
0593 C48E 80                    DC B:canLoad+0                 12 - Text tool set, startup not needed.
0594 C48F 00                    DC B:0                         13 - not used.
0595 C490 80                    DC B:canLoad+0                 14 - Window Manager.
0596 C491 81                    DC B:canLoad+1                 15 - Menu Manager.
0597 C492 81                    DC B:canLoad+1                 16 - Control Manager.
0598 C493 80                    DC B:canLoad+0                 17 - System Loader, startup not needed.
0599 C494 80                    DC B:canLoad+0                 18 - QuickDraw Auxiliary.
0600 C495 82                    DC B:canLoad+2                 19 - Print Manager.
0601 C496 81                    DC B:canLoad+1                 20 - LineEdit
0602 C497 80                    DC B:canLoad+0                 21 - Dialog Manager.
0603 C498 80                    DC B:canLoad+0                 22 - Scrap Manager.
0604 C499 81                    DC B:canLoad+1                 23 - Standard File Operations.
0605 C49A 80                    DC B:canLoad+0                 24 - future Tool.
0606 C49B 80                    DC B:canLoad+0                 25 - Note synthesizer.
0607 C49C 83                    DC B:canLoad+3                 26 - Note sequencer.
0608 C49D 81                    DC B:canLoad+1                 27 - Font Manager.
0609 C49E 80                    DC B:canLoad+0                 28 - List Manager, startup not needed.
0610 C49F 81                    DC B:canLoad+1                 29 - ACE
0611 C4A0 80                    DC B:canLoad+0                 30 - Resource Manager, startup always happens.
0612 C4A1 80                    DC B:canLoad+0                 31 - not used.
0613 C4A2 83                    DC B:canLoad+3                 32 - MIDI
0614 C4A3 80                    DC B:canLoad+0                 33 - Pokey
0615 C4A4 81                    DC B:canLoad+1                 34 - Text edit.
0616 C4A5              endTools  
0617 C4A5
0618 C4A5
0619 C4A5
0620 C4A5              **********************************************************************
0621 C4A5              *
0622 C4A5              *   Load tool.
0623 C4A5              *
0624 C4A5              *
0625 C4A5              *   IN: 
0626 C4A5              *        y          = index to tool in startup record.
0627 C4A5              *        a          = tool number.
0628 C4A5              *        <numPages  = next available direct page.
0629 C4A5              *        <loading   = TRUE to load tools.
0630 C4A5              *
0631 C4A5              *  OUT:  Carry set if error, y = error code.
0632 C4A5              *
0633 C4A5              **********************************************************************
0634 C4A5                       import ReportIfMissing 
0635 C4A5
0636 C4A5                       entry buildLoadTable 
0637 C4A5              buildLoadTable  
0638 C4A5 C9 23 00              cmp   #endTools-toolTable      Tool number in range?
0639 C4A8 B0 09                 bcs   @OkToTry
0640 C4AA
0641 C4AA AA                    tax   
0642 C4AB BD 82 C4              lda   |toolTable,x             ;Is there a loader for the tool?
0643 C4AE 29 FF 00              and   #$00FF
0644 C4B1 F0 2E                 beq   @cantError
0645 C4B3
0646 C4B3              @OkToTry  
0647 C4B3              ;
0648 C4B3 A5 01                 lda   <loading                 Am I loading tools?
0649 C4B5 F0 13                 beq   @skip1
0650 C4B7              ;
0651 C4B7 DA                    phx                            Save tool number.
0652 C4B8              ;
0653 C4B8 DA                    phx                            Pass tool number.
0654 C4B9 C8                    iny   
0655 C4BA C8                    iny   
0656 C4BB B7 2A                 lda   [<startRec],y            Pass minimum tool version.
0657 C4BD 48                    pha   
0658 C4BE A2 01 0F 22           _LoadOneTool 
0659 C4C5 A8                    tay                            Possible error code.
0660 C4C6 FA                    plx                            Restore tool number.
0661 C4C7 90 01                 bcc   @skip1
0662 C4C9 60                    rts                            Abort.
0663 C4CA
0664 C4CA 8A           @skip1   txa                            Compute index to bit in LoadTable.
0665 C4CB 29 07 00              and   #$0007
0666 C4CE A8                    tay   
0667 C4CF              ;
0668 C4CF 8A                    txa   
0669 C4D0 4A                    lsr   a
0670 C4D1 4A                    lsr   a
0671 C4D2 4A                    lsr   a
0672 C4D3 AA                    tax   
0673 C4D4              ;
0674 C4D4 E2 20                 sep   #$20                     Set bit in hash table for tool to be loaded.
0675 C4D6                       LONGA OFF
0676 C4D6 B5 03                 lda   <loadTable,x
0677 C4D8 19 E6 C4              ora   |loadMasks,y
0678 C4DB 95 03                 sta   <loadTable,x
0679 C4DD C2 20                 rep   #$20
0680 C4DF                       LONGA ON
0681 C4DF              ;
0682 C4DF 18                    clc                            Continue flag.
0683 C4E0 60                    rts   
0684 C4E1              ;
0685 C4E1 A0 04 01     @cantError ldy   #TLCantLoad            Error code.
0686 C4E4 38                    sec   
0687 C4E5 60                    rts   
0688 C4E6              ;
0689 C4E6 80 40 20 10  loadMasks DC B:$80,$40,$20,$10,$08,$04,$02,$01
0690 C4EE
0691 C4EE
0692 C4EE              **********************************************************************
0693 C4EE              *
0694 C4EE              *   Check loadTable if tool should be loaded.
0695 C4EE              *
0696 C4EE              *
0697 C4EE              *   IN: a           = tool number, already checked for being in range.
0698 C4EE              *       <loadTable  = pointer to load table.
0699 C4EE              *
0700 C4EE              **********************************************************************
0701 C4EE
0702 C4EE                       entry checkLoadTable 
0703 C4EE 48           checkLoadTable pha   
0704 C4EF 29 07 00              and   #$0007
0705 C4F2 A8                    tay   
0706 C4F3
0707 C4F3 68                    pla   
0708 C4F4 4A                    lsr   a
0709 C4F5 4A                    lsr   a
0710 C4F6 4A                    lsr   a
0711 C4F7 AA                    tax   
0712 C4F8
0713 C4F8 E2 20                 sep   #$20
0714 C4FA                       LONGA OFF
0715 C4FA B5 03                 lda   <loadTable,x
0716 C4FC 39 E6 C4              and   |loadMasks,y
0717 C4FF C2 20                 rep   #$20
0718 C501                       LONGA ON
0719 C501 60                    rts   
0720 C502                       ENDP 
0721 C502
0722 C502
0723 C502
0724 C502              ****************************************************************
0725 C502              *
0726 C502              ShutdownTools PROC EXPORT 
0727 C502              *
0728 C502              *   If handle of startup record is passed the handle is disposed of.
0729 C502              *
0730 C502              *
0731 C502              *   IN: 
0732 C502              *     PUSH:WORD - 0 if startup record is a pointer, 2 if a handle.
0733 C502              *     PUSH:LONG - pointer or handle of startup record.
0734 C502              *
0735 C502              *  OUT: 
0736 C502              *     Nothing.
0737 C502              *
0738 C502              * Outputs:
0739 C502              *                   none
0740 C502              *
0741 C502              * External Refs:
0742 C502                       IMPORT startCall 
0743 C502                       IMPORT getStartupPtr 
0744 C502                       IMPORT checkLoadTable 
0745 C502                       IMPORT walkToolArray 
0746 C502                       import KillIt 
0747 C502                       IMPORT StopNoteSynth 
0748 C502                       IMPORT StopSound 
0749 C502                       import StopMM 
0750 C502                       import stopQuickDraw 
0751 C502                       import stopMenuMgr 
0752 C502
0753 C502              *
0754 C502              *
0755 C502              * Entry Points:
0756 C502              *                   none
0757 C502              *
0758 C502                       longa on                       ; mode
0759 C502                       longi on
0760 C502              *
0761 C502              ****************************************************************
0762 C502
0763 C502 20 37 C6              jsr   startCall                ;Allocate a direct page.
0764 C505
0765 C505 20 E3 C5              jsr   getStartupPtr            ;Get startup record pointer.
0766 C508 90 03                 bcc   @ok1                     ;Error?  Y = error code.
0767 C50A 82 65 00              brl   @errOut
0768 C50D
0769 C50D 64 03        @ok1     stz   <loadTable               ;Clear tool load table.
0770 C50F 64 05                 stz   <loadTable+2
0771 C511 64 07                 stz   <loadTable+4
0772 C513 64 01                 stz   <loading                 ;FALSE for no loading.
0773 C515
0774 C515 A9 A5 C4              lda   #buildLoadTable          ;Build hash table of tools that were loaded.
0775 C518 20 EE C6              jsr   walkToolArray
0776 C51B
0777 C51B
0778 C51B              ;-----------------------------------------------------------
0779 C51B              ; 
0780 C51B              ; Shutdown loop.
0781 C51B              ;
0782 C51B A2 00 00              ldx   #0
0783 C51E 80 28                 bra   @enter1
0784 C520 DA           @lop1    phx   
0785 C521              ;
0786 C521 20 EE C4              jsr   checkLoadTable           Check if user wants this tool started.
0787 C524 18                    clc                            Make flag correct.
0788 C525 F0 1B                 beq   @next1
0789 C527              ;
0790 C527 FA                    plx                            Call shutdown handler.
0791 C528 DA                    phx   
0792 C529 BD 9B C5              lda   |shutdownTable+1,x       Is there a handler?
0793 C52C D0 10                 bne   @ok2
0794 C52E              ;
0795 C52E BD 9A C5              lda   |shutdownTable,x         Compute shutdown call number.
0796 C531 29 FF 00              and   #$00FF
0797 C534 09 00 03              ora   #$0300
0798 C537 AA                    tax   
0799 C538 22 00 00 E1           jsl   $E10000                  Call tool's shutdown, no parameters.
0800 C53C 80 03                 bra   @enter2
0801 C53E              ;
0802 C53E FC 9B C5     @ok2     jsr   (shutdownTable+1,x)
0803 C541 A8           @enter2  tay                            Possible error code into y.
0804 C542 FA           @next1   plx   
0805 C543 B0 2D                 bcs   @errOut                  Error?
0806 C545              ;
0807 C545 E8                    inx                            Next tool.
0808 C546 E8                    inx   
0809 C547 E8                    inx   
0810 C548 BD 9A C5     @enter1  lda   |shutdownTable,x         Next tool to shutdown.
0811 C54B 29 FF 00              and   #$00FF
0812 C54E D0 D0                 bne   @lop1                    Any more tools?
0813 C550
0814 C550
0815 C550              ;-----------------------------------------------------------
0816 C550              ;
0817 C550              ; Dispose of the handle we allocated for direct page.
0818 C550              ;
0819 C550 A0 08 00              ldy   #StartStopRecord.DPageHandle+2
0820 C553 B7 2A                 lda   [startrec],y
0821 C555 AA                    tax   
0822 C556 88                    dey   
0823 C557 88                    dey   
0824 C558 B7 2A                 lda   [startrec],y
0825 C55A 20 CC C8              jsr   KillIt
0826 C55D
0827 C55D              ;-----------------------------------------------------------
0828 C55D              ;
0829 C55D              ; If the input to this call is a handle, dispose of it.
0830 C55D              ;
0831 C55D A5 2E                 lda   <StartRecFlag
0832 C55F F0 07                 beq   @NotHandle
0833 C561 A5 15                 lda   <handle
0834 C563 A6 17                 ldx   <handle+2
0835 C565 20 CC C8              jsr   KillIt
0836 C568
0837 C568              @NotHandle  
0838 C568
0839 C568              ;-----------------------------------------------------------
0840 C568              ;
0841 C568              ; We log off the res mgr last just in case any of the
0842 C568              ; other tools need the res mgr to shut down.
0843 C568              ;
0844 C568
0845 C568              ;;;	lda	<startRecFlag
0846 C568              ;;;	and	#skipResMgr
0847 C568              ;;;	bne	@skipRMSD
0848 C568 A2 1E 03 22           _ResourceShutdown              ;Log off of Resource Manager.
0849 C56F              ;;;@skipRMSD
0850 C56F
0851 C56F A0 00 00              ldy   #0                       ;No error.
0852 C572              ;
0853 C572              ; @errOut -- Exit
0854 C572              ;
0855 C572              @errOut   
0856 C572
0857 C572 A2 06 00              ldx   #6                       ;Number of bytes to strip.
0858 C575
0859 C575                       entry pop 
0860 C575 22 68 00 E1  pop      jsl   DecBusyFlg
0861 C579              ;
0862 C579              ; --- Restore saved parameters from startupCall.
0863 C579              ;
0864 C579              ;
0865 C579 3B                    tsc                            ;Free allocate direct page in stack.
0866 C57A 18                    clc   
0867 C57B 69 20 00              adc   #saveDbank-1
0868 C57E 1B                    tcs   
0869 C57F
0870 C57F AB                    plb                            ;Restore original data bank.
0871 C580
0872 C580              ;
0873 C580              ; --- Move return addresses over top of input parameters.
0874 C580              ;
0875 C580 3B                    tsc   
0876 C581 5B                    tcd   
0877 C582 A3 07                 lda   7,s
0878 C584 95 07                 sta   7,x
0879 C586 A3 05                 lda   5,s
0880 C588 95 05                 sta   5,x
0881 C58A A3 03                 lda   3,s
0882 C58C 95 03                 sta   3,x
0883 C58E
0884 C58E              ;
0885 C58E              ; --- Adjust stact for popped parameters.
0886 C58E              ;
0887 C58E 2B                    pld                            ;Get original direct page pointer.
0888 C58F
0889 C58F 3B                    tsc                            ;Current stack,
0890 C590 DA                    phx   
0891 C591 18                    clc   
0892 C592 63 01                 adc   1,s                      ;plus number of bytes popped,
0893 C594 1B                    tcs                            ;equals new stack.
0894 C595
0895 C595 98                    tya                            ;Return error code in Y.
0896 C596 C9 01 00              cmp   #1                       ;Set carry if error.
0897 C599
0898 C599 6B                    rtl   
0899 C59A
0900 C59A
0901 C59A              **********************************************************************
0902 C59A              *
0903 C59A              * This is the shutdown table.  To add a tool to be shutdown 
0904 C59A              * add a record to this table at the position you want it to be shutdown.
0905 C59A              * The first tool shutdown is the first tool in the table.
0906 C59A              * A record is a one byte tool number followed by a one word 
0907 C59A              * address of a routine that shutdown the tool or zero to just call 
0908 C59A              * its shutdown call.  The routine should shutdown the tool and 
0909 C59A              * return carry set if there is an error with an error code in a.
0910 C59A              *
0911 C59A              * Change History
0912 C59A              *
0913 C59A              * 06 Feb 89         Steven Glass
0914 C59A              *
0915 C59A              * Added tool locator to end of list.
0916 C59A              *
0917 C59A              **********************************************************************
0918 C59A              shutdownTable  
0919 C59A 05                    DC B:5                         ;Desk Mgr
0920 C59B 00 00                 DC W:0
0921 C59D 21                    DC B:33                        ;Video Overlay
0922 C59E 00 00                 DC W:0
0923 C5A0 0A                    DC B:10                        ;SANE
0924 C5A1 00 00                 DC W:0
0925 C5A3 1D                    DC B:29                        ;ACE
0926 C5A4 00 00                 DC W:0
0927 C5A6 1A                    DC B:NoteSeq                   ;Note sequencer
0928 C5A7 00 00                 DC W:0
0929 C5A9 20                    DC B:MIDITools                 ;MIDI
0930 C5AA 00 00                 DC W:0
0931 C5AC 19                    DC B:NoteSynth                 ;Note Synth
0932 C5AD 2E C8                 DC W:StopNoteSynth
0933 C5AF 08                    DC B:8                         ;Sound Tool
0934 C5B0 37 C8                 DC W:StopSound
0935 C5B2 22                    DC B:34                        ;Text Edit
0936 C5B3 00 00                 DC W:0
0937 C5B5 13                    DC B:19                        ;Print Mgr
0938 C5B6 00 00                 DC W:0
0939 C5B8 1B                    DC B:27                        ;Font Mgr
0940 C5B9 00 00                 DC W:0
0941 C5BB 17                    DC B:23                        ;Standard File
0942 C5BC 00 00                 DC W:stopStdFile
0943 C5BE 15                    DC B:21                        ;Dialog Mgr
0944 C5BF 00 00                 DC W:0
0945 C5C1 16                    DC B:22                        ;Scrap Mgr
0946 C5C2 00 00                 DC W:0
0947 C5C4 14                    DC B:20                        ;Line Edit
0948 C5C5 00 00                 DC W:0
0949 C5C7 0F                    DC B:15                        ;Menu Mgr
0950 C5C8 00 00                 DC W:stopMenuMgr
0951 C5CA 10                    DC B:16                        ;Control Mgr
0952 C5CB 00 00                 DC W:0
0953 C5CD 0E                    DC B:14                        ;Window Manager
0954 C5CE 00 00                 DC W:0
0955 C5D0 06                    DC B:6                         ;Event Mgr
0956 C5D1 00 00                 DC W:0
0957 C5D3 12                    DC B:18                        ;QD Aux
0958 C5D4 00 00                 DC W:0
0959 C5D6 04                    DC B:4                         ;Quick Draw
0960 C5D7 00 00                 DC W:stopQuickDraw
0961 C5D9 03                    DC B:3                         ;Misc. Tools
0962 C5DA 00 00                 DC W:0
0963 C5DC 02                    DC B:2                         ;Memory Manager
0964 C5DD 2D C8                 DC W:StopMM
0965 C5DF 01                    DC B:1                         ;Tool Locator
0966 C5E0 00 00                 DC W:0
0967 C5E2 00                    DC B:0                         ;(No more tools)
0968 C5E3
0969 C5E3                       ENDP 
0970 C5E3
0971 C5E3
0972 C5E3              ****************************************************************
0973 C5E3              *
0974 C5E3              getStartupPtr PROC 
0975 C5E3              *
0976 C5E3              * Description
0977 C5E3              *
0978 C5E3              *
0979 C5E3              * Inputs:
0980 C5E3              *                   none
0981 C5E3              *
0982 C5E3              * Outputs:
0983 C5E3              *        <handle = handle of startup record, NIL if none.
0984 C5E3              *        <startRec = pointer to startup record.
0985 C5E3              *        Carry set if error, y = error code.
0986 C5E3              *
0987 C5E3              * External Refs:
0988 C5E3                       IMPORT derefHand 
0989 C5E3              *
0990 C5E3              * Entry Points:
0991 C5E3              *                   none
0992 C5E3              *
0993 C5E3                       longa on                       ; mode
0994 C5E3                       longi on
0995 C5E3              *
0996 C5E3              ****************************************************************
0997 C5E3
0998 C5E3 A0 03 01              ldy   #TLBadRecFlag            ;Possible error code.
0999 C5E6 A5 2E                 lda   <startRecFlag            ;Dispatch to converter.
1000 C5E8 0A                    asl   a
1001 C5E9 AA                    tax   
1002 C5EA E0 05 00              cpx   #5
1003 C5ED B0 47                 bcs   @errOut
1004 C5EF 7C F2 C5              jmp   (@converters,x)
1005 C5F2 2D C6        @converters DC W:@pointer
1006 C5F4 F8 C5                 DC W:@hand
1007 C5F6 03 C6                 DC W:@res
1008 C5F8              ;
1009 C5F8              ;
1010 C5F8              ; ------ Startup record is a handle.
1011 C5F8              ;
1012 C5F8 A5 2A        @hand    lda   <startRec                ;Save handle.
1013 C5FA A6 2C                 ldx   <startRec+2
1014 C5FC 85 15                 sta   <handle
1015 C5FE 86 17                 stx   <handle+2
1016 C600 82 46 00              brl   derefHand                ;<startRec = (<handle)
1017 C603              ;
1018 C603              ;
1019 C603              ; ------ Startup record is a resource ID.
1020 C603              ;
1021 C603 48           @res     pha                            ;Space for result.
1022 C604 48                    pha   
1023 C605 F4 13 80              pea   rToolStartup             ;Pass resource type of resource startup record.
1024 C608 D4 2C                 pei   <startRec+2              ;Pass resource ID of resource startup record.
1025 C60A D4 2A                 pei   <startRec
1026 C60C A2 1E 0E 22           _LoadResource 
1027 C613 A8                    tay                            ;Put possible error code in y.
1028 C614 68                    pla   
1029 C615 FA                    plx   
1030 C616 B0 1E                 bcs   @errOut
1031 C618              ;
1032 C618 85 15                 sta   <handle
1033 C61A 86 17                 stx   <handle+2
1034 C61C              ;
1035 C61C F4 13 80              pea   rToolStartup             ;Pass resource type of resource startup record.
1036 C61F D4 2C                 pei   <startRec+2              ;Pass resource ID of resource startup record.
1037 C621 D4 2A                 pei   <startRec
1038 C623 A2 1E 18 22           _DetachResource                ;Let startup record float.
1039 C62A              ;
1040 C62A 82 1C 00              brl   derefHand                ;<startRec = (<handle)
1041 C62D              ;
1042 C62D              ;
1043 C62D              ; ------ Startup record is a pointer.
1044 C62D              ;
1045 C62D A5 2A        @pointer lda   startRec                 No handle so copy pointer to handle to use
1046 C62F 85 15                 sta   <handle                  as output
1047 C631 A5 2C                 lda   startRec+2
1048 C633 85 17                 sta   <handle+2
1049 C635
1050 C635 18                    clc                            No error.
1051 C636 60           @errOut  rts   
1052 C637
1053 C637                       ENDP 
1054 C637
1055 C637
1056 C637              ****************************************************************
1057 C637              *
1058 C637              startCall PROC 
1059 C637              *
1060 C637              * Incs the busy flag, and gets d-page off stack for use
1061 C637              * in call.
1062 C637              *
1063 C637              *
1064 C637              * Inputs:
1065 C637              *                   none
1066 C637              *
1067 C637              * Outputs:
1068 C637              *                   none
1069 C637              *
1070 C637              * External Refs:
1071 C637              *                   none
1072 C637              *
1073 C637              * Entry Points:
1074 C637              *                   none
1075 C637              *
1076 C637                       longa on                       ; mode
1077 C637                       longi on
1078 C637              *
1079 C637              ****************************************************************
1080 C637
1081 C637              ;
1082 C637 22 64 00 E1           jsl   IncBusyFlg
1083 C63B              ;
1084 C63B FA                    plx                            Get caller's return address.
1085 C63C              ;
1086 C63C 0B                    phd                            Save caller's direct page pointer.
1087 C63D 8B                    phb                            Save caller's data bank pointer.
1088 C63E 4B                    phk   
1089 C63F AB                    plb   
1090 C640              ;
1091 C640 3B                    tsc                            Allocate direct page in stack.
1092 C641 38                    sec   
1093 C642 E9 20 00              sbc   #saveDbank-1
1094 C645 1B                    tcs   
1095 C646 5B                    tcd   
1096 C647              ;
1097 C647 DA                    phx                            Put return address back.
1098 C648 60                    rts   
1099 C649
1100 C649
1101 C649                       ENDP 
1102 C649
1103 C649
1104 C649              ****************************************************************
1105 C649              *
1106 C649              derefHand PROC 
1107 C649              *
1108 C649              * Derefernce handle of startup record if there is a handle.
1109 C649              *
1110 C649              *
1111 C649              * Inputs:
1112 C649              *                   handle
1113 C649              *
1114 C649              * Outputs:
1115 C649              *                   startRec
1116 C649              *
1117 C649              * External Refs:
1118 C649              *                   none
1119 C649              *
1120 C649              * Entry Points:
1121 C649              *                   none
1122 C649              *
1123 C649                       longa on                       ; mode
1124 C649                       longi on
1125 C649              *
1126 C649              ****************************************************************
1127 C649
1128 C649              ;
1129 C649 A5 16                 lda   <handle+1                NIL handle?
1130 C64B F0 15                 beq   @exit
1131 C64D              ;
1132 C64D A0 04 00              ldy   #4                       Lock the handle  (added 30 Mar 89)
1133 C650 B7 15                 lda   [<handle],y
1134 C652 09 00 80              ora   #$8000
1135 C655 97 15                 sta   [<handle],y
1136 C657
1137 C657 A0 02 00              ldy   #2                       Dereference the handle.
1138 C65A B7 15                 lda   [<handle],y
1139 C65C 85 2C                 sta   <startRec+2
1140 C65E A7 15                 lda   [<handle]
1141 C660 85 2A                 sta   <startRec
1142 C662              ;
1143 C662 18           @exit    clc                            No error.
1144 C663 60                    rts   
1145 C664                       ENDP 
1146 C664
1147 C664
1148 C664
1149 C664              ****************************************************************
1150 C664              *
1151 C664              openAppRes PROC 
1152 C664              *
1153 C664              * Open the application's resource fork.
1154 C664              *
1155 C664              *
1156 C664              * Inputs:
1157 C664              *                   direct page stuff
1158 C664              *
1159 C664              * Outputs:
1160 C664              *                   a-reg = openfile id, NIL if none
1161 C664              *                   SEC = bad error (in Y) (added 1-Jul-92)
1162 C664              *
1163 C664              * External Refs:
1164 C664                       import KillIt 
1165 C664              *
1166 C664              * Entry Points:
1167 C664              *                   none
1168 C664              *
1169 C664                       longa on                       ; mode
1170 C664                       longi on
1171 C664              *
1172 C664              ****************************************************************
1173 C664
1174 C664 48                    pha                            ;Is the Resource Manager loaded?
1175 C665 A2 1E 06 22           _ResourceStatus 
1176 C66C 68                    pla   
1177 C66D B0 7B                 bcs   @errOut
1178 C66F
1179 C66F D4 30                 pei   <userID                  ;Pass user ID.
1180 C671 A2 1E 02 22           _ResourceStartUp               ;Log application in with Resource Manager.
1181 C678              ;
1182 C678              ; ------ Get name of application.
1183 C678              ;
1184 C678 48                    pha                            ;Space for result.
1185 C679 48                    pha   
1186 C67A F4 00 00              pea   0                        ;Pass number of bytes to allocate.
1187 C67D F4 00 04              pea   1024
1188 C680 D4 30                 pei   <userID                  ;Pass user ID.
1189 C682 F4 00 C0              pea   $C000                    ;Pass attributes, fixed.
1190 C685 48                    pha                            ;Pass address, not used.
1191 C686 48                    pha   
1192 C687 A2 02 09 22           _NewHandle 
1193 C68E FA                    plx   
1194 C68F 86 15                 stx   <handle
1195 C691 FA                    plx   
1196 C692 86 17                 stx   <handle+2
1197 C694 A8                    tay                            ;Possible error code.
1198 C695 B0 53                 bcs   @errOut
1199 C697
1200 C697 A0 02 00              ldy   #2                       ;Dereference the handle.
1201 C69A B7 15                 lda   [<handle],y
1202 C69C 85 13                 sta   <getName+2
1203 C69E A7 15                 lda   [<handle]
1204 C6A0 85 11                 sta   <getName
1205 C6A2
1206 C6A2
1207 C6A2              *** The old way:  use "1/" + GetName (17-Nov-90 DAL)
1208 C6A2              ;
1209 C6A2 A9 00 04              lda   #1024                    Size of name buffer.
1210 C6A5 87 11                 sta   [<getName]
1211 C6A7              ;
1212 C6A7 A9 01 00              lda   #1                       Initialize parameter block.
1213 C6AA 85 0F                 sta   <getNameBlk
1214 C6AC              ;
1215 C6AC F4 00 00              pea   0                        Pass pointer to parameter block.
1216 C6AF 7B                    tdc   
1217 C6B0 18                    clc   
1218 C6B1 69 0F 00              adc   #getNameBlk
1219 C6B4 48                    pha   
1220 C6B5 F4 27 20              pea   $2027                    GetName.
1221 C6B8 22 B0 00 E1           jsl   $E100B0                  Call GS/OS to get the name of the appliation.
1222 C6BC              ;
1223 C6BC A0 02 00              ldy   #2                       Get length of name,
1224 C6BF B7 11                 lda   [<getName],y
1225 C6C1 1A                    inc   a                        add size of prefix to be added,
1226 C6C2 1A                    inc   a
1227 C6C3 87 11                 sta   [<getName]               turn into an input name.
1228 C6C5              ;
1229 C6C5 A9 31 2F              lda   #$2F31                   Add application prefix '1/'
1230 C6C8 97 11                 sta   [<getName],y
1231 C6CA
1232 C6CA
1233 C6CA              ; Let me take a moment to say how much fun it is to
1234 C6CA              ; get the application's pathname.  And soooo easy too!
1235 C6CA
1236 C6CA 48                    pha   
1237 C6CB F4 01 00              pea   1                        ;file number
1238 C6CE A9 00 00              lda   #0                       ;Pass map pointer, none.
1239 C6D1 48                    pha   
1240 C6D2 48                    pha   
1241 C6D3 D4 13                 pei   <getName+2               ;Pass pointer to GS/OS input name of application.
1242 C6D5 D4 11                 pei   <getName
1243 C6D7 A2 1E 0A 22           _OpenResourceFile 
1244 C6DE
1245 C6DE 08           @pathError php                          ;Save result.
1246 C6DF
1247 C6DF A6 17                 ldx   <handle+2                ;Free pathname buffer.
1248 C6E1 A5 15                 lda   <handle
1249 C6E3 20 CC C8              jsr   KillIt
1250 C6E6
1251 C6E6 28                    plp                            ;Restore status.
1252 C6E7 68                    pla                            ;Get file ID returned by OpenResource (or 2nd word of LGetPathname2 result)
1253 C6E8 90 03                 bcc   @exit
1254 C6EA
1255 C6EA A9 00 00     @errOut  lda   #0                       ;Return no open file ID.
1256 C6ED 60           @exit    rts   
1257 C6EE
1258 C6EE                       ENDP 
1259 C6EE
1260 C6EE
1261 C6EE
1262 C6EE              ****************************************************************
1263 C6EE              *
1264 C6EE              walkToolArray PROC 
1265 C6EE              *
1266 C6EE              * Calls the indicated routine for each tool in the array.  The
1267 C6EE              * indicated routine is called with following inputs:
1268 C6EE              *
1269 C6EE              *                   y = index to tool in startup record
1270 C6EE              *
1271 C6EE              * The output from the routine is the carry flag: set to abort.
1272 C6EE              *
1273 C6EE              *
1274 C6EE              *   IN: 
1275 C6EE              *      a =          address of routine to call for each tool in the array.
1276 C6EE              *      <startRec =  pointer to start record that contains the tool array.
1277 C6EE              *
1278 C6EE              *  OUT: 
1279 C6EE              *      Carry set if routine aborted walk.
1280 C6EE              *      Carry clear if entire list walk.
1281 C6EE              *
1282 C6EE              *
1283 C6EE              * External Refs:
1284 C6EE              *                   none
1285 C6EE              *
1286 C6EE              * Entry Points:
1287 C6EE              *                   none
1288 C6EE              *
1289 C6EE                       longa on                       ; mode
1290 C6EE                       longi on
1291 C6EE              *
1292 C6EE              ****************************************************************
1293 C6EE
1294 C6EE              @saveToolIndex equ   1
1295 C6EE              @saveToolCounter equ   @saveToolIndex+2
1296 C6EE              @routine equ   @saveToolCounter+2
1297 C6EE
1298 C6EE 3A                    dec   a                        ;Make address a return address.
1299 C6EF 48                    pha                            ;Save address.
1300 C6F0
1301 C6F0 A0 0A 00              ldy   #StartStopRecord.NumTools ;Get number of tools in array.
1302 C6F3 B7 2A                 lda   [<startRec],y
1303 C6F5 AA                    tax   
1304 C6F6 C8                    iny                            ;Index to first tool.
1305 C6F7 C8                    iny   
1306 C6F8 80 14                 bra   @enter1
1307 C6FA
1308 C6FA DA           @lop1    phx                            ;Save tool counter.
1309 C6FB 5A                    phy                            ;Save tool index.
1310 C6FC
1311 C6FC A3 05                 lda   @routine,s
1312 C6FE F4 04 C7              pea   @return-1                ;Put return address on stack.
1313 C701 48                    pha                            ;Dispatch to routine to call.
1314 C702 B7 2A                 lda   [<startRec],y            ;Pass tool number.
1315 C704 60                    rts   
1316 C705 68           @return  pla   
1317 C706 FA                    plx   
1318 C707 B0 09                 bcs   @exit                    ;Did routine abort?
1319 C709
1320 C709 18                    clc                            ;Increment index to next tool element.
1321 C70A 69 04 00              adc   #4
1322 C70D A8                    tay   
1323 C70E
1324 C70E CA           @enter1  dex                            ;Any more tools?
1325 C70F 10 E9                 bpl   @lop1
1326 C711
1327 C711 18                    clc                            ;Entire array walked flag.
1328 C712 68           @exit    pla                            ;Get rid of return address.
1329 C713 60                    rts   
1330 C714                       ENDP 
1331 C714
1332 C714
1333 C714              ;=====================================================================
1334 C714              ;   Pass pointer to direct page and increment counter.
1335 C714              ;=====================================================================
1336 C714              ;
1337 C714              ;   IN: a = tool number, range already checked.
1338 C714              ;   <directPages = handle of direct pages.
1339 C714              ;   <numPages = next available direct page.
1340 C714              ;
1341 C714              ;  OUT: Pointer to available direct page on stack.
1342 C714              ;   <numPages = next available direct page.
1343 C714              ;
1344 C714              pushDirectPage PROC 
1345 C714
1346 C714                       IMPORT toolTable 
1347 C714
1348 C714 A8                    tay                            ;Save tool number.
1349 C715
1350 C715 FA                    plx                            ;Pull return address.
1351 C716 A7 09                 lda   [<directPages]           ;Push pointer to next available direct page.
1352 C718 18                    clc   
1353 C719 65 0D                 adc   <numPages
1354 C71B 48                    pha   
1355 C71C DA                    phx                            ;Put return address back.
1356 C71D
1357 C71D B9 82 C4              lda   |toolTable,y             ;Increment page counter.
1358 C720 29 7F 00              and   #$007F
1359 C723 EB                    xba   
1360 C724 18                    clc   
1361 C725 65 0D                 adc   <numPages
1362 C727 85 0D                 sta   <numPages
1363 C729 60                    rts   
1364 C72A
1365 C72A                       ENDP 
1366 C72A
1367 C72A
1368 C72A              ;*************************************************************************************
1369 C72A              ;           Tool Startup handlers.
1370 C72A              ;*************************************************************************************
1371 C72A
1372 C72A              ;===========================================
1373 C72A              ;   Start Miscellaneous Tools.
1374 C72A              ;===========================================
1375 C72A
1376 C72A              startMiscTools PROC 
1377 C72A
1378 C72A A2 03 02 22           _MTStartup 
1379 C731 60                    rts   
1380 C732                       ENDP 
1381 C732
1382 C732
1383 C732              ;===========================================
1384 C732              ;   Start QuickDraw.
1385 C732              ;===========================================
1386 C732
1387 C732              startQuickDraw PROC 
1388 C732
1389 C732                       IMPORT pushDirectPage 
1390 C732
1391 C732 A9 04 00              lda   #4                       ;Pass address of QuickDraw's direct pages.
1392 C735 20 14 C7              jsr   pushDirectPage
1393 C738 A0 02 00              ldy   #StartStopRecord.VideoMode ;Pass video mode to start in.
1394 C73B B7 2A                 lda   [<startRec],y
1395 C73D 48                    pha   
1396 C73E F4 A0 00              pea   160                      ;Pass bytes per scan line.
1397 C741 D4 30                 pei   <userID                  ;Pass user ID.
1398 C743 A2 04 02 22           _QDStartup 
1399 C74A B0 07                 bcs   @errOut2
1400 C74C
1401 C74C A2 04 91 22           _ShowCursor                    ;Turn on cursor.
1402 C753 60           @errOut2 rts   
1403 C754                       ENDP 
1404 C754
1405 C754
1406 C754              ;===========================================
1407 C754              ;   Start QuickDraw Aux.
1408 C754              ;===========================================
1409 C754
1410 C754              startQDAux PROC 
1411 C754
1412 C754 A2 12 02 22           _QDAuxStartup 
1413 C75B A2 12 0A 22           _WaitCursor 
1414 C762
1415 C762 60                    rts   
1416 C763                       ENDP 
1417 C763
1418 C763
1419 C763              ;===========================================
1420 C763              ;   Start Event Manager.
1421 C763              ;===========================================
1422 C763
1423 C763              startEventMgr PROC 
1424 C763
1425 C763                       IMPORT pushDirectPage 
1426 C763
1427 C763 A9 06 00              lda   #6                       ;pointer to Event Manager direct page.
1428 C766 20 14 C7              jsr   pushDirectPage
1429 C769 F4 14 00              pea   20                       ;queue size.
1430 C76C F4 00 00              pea   0                        ;minimum x mouse clamp.
1431 C76F A2 80 02              ldx   #640
1432 C772 A0 02 00              ldy   #StartStopRecord.VideoMode ;video mode to start in.
1433 C775 B7 2A                 lda   [<startRec],y
1434 C777 29 FF 00              and   #$00FF                   ;Added by DDG to fix shadowed QD bug
1435 C77A D0 03                 bne   @okEM
1436 C77C A2 40 01              ldx   #320
1437 C77F DA           @okEM    phx                            ;maximum x mouse clamp.
1438 C780 F4 00 00              pea   0                        ;minimum y mouse clamp.
1439 C783 F4 C8 00              pea   200                      ;maximum y mouse clamp.
1440 C786 D4 30                 pei   <userID                  ;application's user ID.
1441 C788 A2 06 02 22           _EMStartup 
1442 C78F 60                    rts   
1443 C790
1444 C790                       ENDP 
1445 C790
1446 C790
1447 C790              ;===========================================
1448 C790              ;   Start Window Manager.
1449 C790              ;===========================================
1450 C790
1451 C790              startWindowMgr PROC 
1452 C790
1453 C790 D4 30                 pei   <userID                  ;Pass application's user ID.
1454 C792 A2 0E 02 22           _WindStartup 
1455 C799 B0 0D                 bcs   @toerrOut2
1456 C79B
1457 C79B F4 00 00              pea   0                        ;Pass 'entire screen' flag.
1458 C79E F4 00 00              pea   0
1459 C7A1 A2 0E 39 22           _RefreshDesktop                ;Draw screen.
1460 C7A8 60           @toerrOut2 rts   
1461 C7A9                       ENDP 
1462 C7A9
1463 C7A9
1464 C7A9              ;===========================================
1465 C7A9              ;   Start Control Manager.
1466 C7A9              ;===========================================
1467 C7A9
1468 C7A9              startControlMgr PROC 
1469 C7A9
1470 C7A9                       IMPORT pushDirectPage 
1471 C7A9
1472 C7A9 D4 30                 pei   <userID                  ;Pass application's user ID.
1473 C7AB A9 10 00              lda   #16                      ;Pass pointer to Control Manager direct page.
1474 C7AE 20 14 C7              jsr   pushDirectPage
1475 C7B1 A2 10 02 22           _CtlStartup 
1476 C7B8 60                    rts   
1477 C7B9                       ENDP 
1478 C7B9
1479 C7B9
1480 C7B9              ;===========================================
1481 C7B9              ;   Start Menu Manager.
1482 C7B9              ;===========================================
1483 C7B9
1484 C7B9              startMenuMgr PROC 
1485 C7B9
1486 C7B9                       IMPORT pushDirectPage 
1487 C7B9
1488 C7B9 D4 30                 pei   <userID                  ;Pass application's user ID.
1489 C7BB A9 0F 00              lda   #15                      ;Pass pointer to direct page.
1490 C7BE 20 14 C7              jsr   pushDirectPage
1491 C7C1 A2 0F 02 22           _MenuStartup 
1492 C7C8 60                    rts   
1493 C7C9                       ENDP 
1494 C7C9
1495 C7C9
1496 C7C9              ;===========================================
1497 C7C9              ;   Start Dialog Manager.
1498 C7C9              ;===========================================
1499 C7C9
1500 C7C9              startDialog PROC 
1501 C7C9
1502 C7C9 D4 30                 pei   <userID                  ;Pass application's user ID.
1503 C7CB A2 15 02 22           _DialogStartup 
1504 C7D2 60                    rts   
1505 C7D3                       ENDP 
1506 C7D3
1507 C7D3
1508 C7D3              ;===========================================
1509 C7D3              ;   Start Line Edit.
1510 C7D3              ;===========================================
1511 C7D3
1512 C7D3              startLineEdit PROC 
1513 C7D3
1514 C7D3                       IMPORT pushDirectPage 
1515 C7D3
1516 C7D3 D4 30                 pei   <userID                  ;Pass application's user ID.
1517 C7D5 A9 14 00              lda   #20                      ;Pass pointer to direct page.
1518 C7D8 20 14 C7              jsr   pushDirectPage
1519 C7DB A2 14 02 22           _LEStartup 
1520 C7E2 60                    rts   
1521 C7E3                       ENDP 
1522 C7E3
1523 C7E3
1524 C7E3              ;===========================================
1525 C7E3              ;   Start Standard File.
1526 C7E3              ;===========================================
1527 C7E3
1528 C7E3              startStandardFile PROC 
1529 C7E3
1530 C7E3                       IMPORT pushDirectPage 
1531 C7E3
1532 C7E3 D4 30                 pei   <userID                  ;Pass application's user ID.
1533 C7E5 A9 17 00              lda   #23                      ;Pass pointer to direct page.
1534 C7E8 20 14 C7              jsr   pushDirectPage
1535 C7EB A2 17 02 22           _SFStartup 
1536 C7F2 60                    rts   
1537 C7F3                       ENDP 
1538 C7F3
1539 C7F3
1540 C7F3              ;===========================================
1541 C7F3              ;   Start Desk Manager.
1542 C7F3              ;===========================================
1543 C7F3
1544 C7F3              startDeskMgr PROC 
1545 C7F3 A2 05 02 22           _DeskStartup 
1546 C7FA 60                    rts   
1547 C7FB                       ENDP 
1548 C7FB
1549 C7FB
1550 C7FB              ;===========================================
1551 C7FB              ;   Start Scrap Manager.
1552 C7FB              ;===========================================
1553 C7FB
1554 C7FB              startScrap PROC 
1555 C7FB A2 16 02 22           _ScrapStartup 
1556 C802 60                    rts   
1557 C803                       ENDP 
1558 C803
1559 C803
1560 C803              ;===========================================
1561 C803              ;   Start Sound Tool.
1562 C803              ;                   8 dec 88 Modified to check for note seq startup - Mensch
1563 C803              ;===========================================
1564 C803
1565 C803              startSound PROC 
1566 C803
1567 C803                       IMPORT pushDirectPage 
1568 C803
1569 C803 A5 1D                 lda   <UtilFlags               ;first test to see if we are going to start the seq
1570 C805 29 04 00              and   #WantsSeq
1571 C808 D0 0D                 bne   @done                    ;if so, then skip NoteSynth startup
1572 C80A A9 08 00              lda   #8                       ;Pass pointer to direct page.
1573 C80D 20 14 C7              jsr   pushDirectPage
1574 C810 A2 08 02 22           _SoundStartup 
1575 C817              @done     
1576 C817 60                    rts   
1577 C818                       ENDP 
1578 C818
1579 C818
1580 C818              ;===========================================
1581 C818              ;   Start Note Synth Tool.
1582 C818              ;                   8 dec 88 Added - Mensch
1583 C818              ;===========================================
1584 C818
1585 C818              startNoteSynth PROC 
1586 C818
1587 C818                       IMPORT pushDirectPage 
1588 C818
1589 C818 A5 1D                 lda   <UtilFlags               ;first test to see if we are going to start the seq
1590 C81A 29 04 00              and   #WantsSeq
1591 C81D D0 0D                 bne   @done                    ;if so, then skip NoteSynth startup
1592 C81F
1593 C81F A9 00 00              lda   #0
1594 C822 48                    pha                            ;default update rate
1595 C823 48                    pha                            ;no user update rtn
1596 C824 48                    pha   
1597 C825 A2 19 02 22           _NSStartUp 
1598 C82C              @done     
1599 C82C 60                    rts   
1600 C82D                       ENDP 
1601 C82D
1602 C82D
1603 C82D              ;============================================
1604 C82D              ;    Stop MM (Memory Manager).
1605 C82D              ;                   11 Apr 89 added - Glass
1606 C82D              ; Does nothing.
1607 C82D              ;============================================
1608 C82D              StopResMgr proc 
1609 C82D                       EndP 
1610 C82D              StopMM   PROC 
1611 C82D 60                    rts   
1612 C82E                       ENDP 
1613 C82E
1614 C82E              ;============================================
1615 C82E              ;    Stop Note synth Tool.
1616 C82E              ;                   9 dec 88 added - Mensch
1617 C82E              ;============================================
1618 C82E              StopNoteSynth Proc 
1619 C82E A2 19 03 22           _NSShutDown                    ;shut down note synth and ignore errors
1620 C835 18                    clc                            ;they mean nothing since only error is not started
1621 C836 60                    rts   
1622 C837
1623 C837
1624 C837              ;============================================
1625 C837              ;    Stop Sound Tools
1626 C837              ;                   9 dec 88 added - mensch
1627 C837              ;============================================
1628 C837              StopSound Proc 
1629 C837 A2 08 03 22           _SoundShutDown                 ;ignore errors here
1630 C83E 18                    clc   
1631 C83F 60                    rts   
1632 C840
1633 C840
1634 C840              ;===========================================
1635 C840              ;   Start MIDI tools.
1636 C840              ;                   8 dec 88 Added - Mensch
1637 C840              ;===========================================
1638 C840              startMIDI PROC 
1639 C840
1640 C840                       IMPORT pushDirectPage 
1641 C840
1642 C840 D4 30                 pei   <userID                  ;Pass application's user ID.
1643 C842 A9 20 00              lda   #32                      ;Pass pointer to direct page.
1644 C845 20 14 C7              jsr   pushDirectPage
1645 C848 A2 20 02 22           _MIDIStartup 
1646 C84F
1647 C84F 60                    rts   
1648 C850                       ENDP 
1649 C850
1650 C850
1651 C850              ;===========================================
1652 C850              ;   Start NOTE sequencer.
1653 C850              ;                   8 dec 88 Added - Mensch
1654 C850              ;===========================================
1655 C850              startNoteSeq PROC 
1656 C850
1657 C850                       IMPORT pushDirectPage 
1658 C850
1659 C850 A9 1A 00              lda   #26                      ;Pass pointer to direct page.
1660 C853 20 14 C7              jsr   pushDirectPage
1661 C856 A5 1D                 lda   <UtilFlags               ;see if the user wanted MIDI started up
1662 C858 29 08 00              and   #WantsMIDI
1663 C85B F0 03                 beq   @SNS0010                 ;if not then just push a zero for MODE
1664 C85D A9 00 80              lda   #$8000                   ;if MIDI then set high bit of MODE
1665 C860 48           @SNS0010 pha                            ;push the mode
1666 C861 F4 00 00              pea   $0000                    ;use the standard update rate
1667 C864 F4 14 00              pea   #20                      ;use 20 as the standard increment
1668 C867 A2 1A 02 22           _SeqStartup 
1669 C86E B0 07                 bcs   @SNSErr
1670 C870 A2 1A 14 22           _StopInts                      ;turn off sequencer interupts for now
1671 C877              @SNSErr   
1672 C877 60                    rts   
1673 C878                       ENDP 
1674 C878
1675 C878
1676 C878              ;===========================================
1677 C878              ;   Start ACE.
1678 C878              ;                   8 dec 88 added - Mensch
1679 C878              ;===========================================
1680 C878
1681 C878              startACE PROC 
1682 C878
1683 C878                       IMPORT pushDirectPage 
1684 C878
1685 C878              *** Note that this doesn't call ACEInfo to see how much DP space we need.  17-Nov-90 DAL
1686 C878
1687 C878 A9 1D 00              lda   #29                      ;Pass pointer to direct page.
1688 C87B 20 14 C7              jsr   pushDirectPage
1689 C87E A2 1D 02 22           _ACEStartup 
1690 C885
1691 C885 60                    rts   
1692 C886                       ENDP 
1693 C886
1694 C886              ;===========================================
1695 C886              ;   Start SANE.
1696 C886              ;===========================================
1697 C886
1698 C886              startSANE PROC 
1699 C886
1700 C886                       IMPORT pushDirectPage 
1701 C886
1702 C886 A9 0A 00              lda   #10                      ;Pass pointer to direct page.
1703 C889 20 14 C7              jsr   pushDirectPage
1704 C88C A2 0A 02 22           _SANEStartup 
1705 C893 60                    rts   
1706 C894                       ENDP 
1707 C894
1708 C894              ;===========================================
1709 C894              ;   Start Pokey.
1710 C894              ;===========================================
1711 C894
1712 C894              startPokey PROC 
1713 C894
1714 C894 A2 21 02              ldx   #$0221                   ; _StartVideoMix
1715 C897 22 00 00 E1           jsl   $E10000
1716 C89B 60                    rts   
1717 C89C
1718 C89C                       ENDP 
1719 C89C
1720 C89C              ;===========================================
1721 C89C              ;   Start Print Manager.
1722 C89C              ;===========================================
1723 C89C
1724 C89C              startPrintMgr PROC 
1725 C89C
1726 C89C                       IMPORT pushDirectPage 
1727 C89C
1728 C89C D4 30                 pei   <userID                  ;Pass application's user ID.
1729 C89E A9 13 00              lda   #19                      ;Pass pointer to direct page.
1730 C8A1 20 14 C7              jsr   pushDirectPage
1731 C8A4 A2 13 02 22           _PMStartup 
1732 C8AB 60                    rts   
1733 C8AC                       ENDP 
1734 C8AC
1735 C8AC
1736 C8AC              ;===========================================
1737 C8AC              ;   Start Font Manager.
1738 C8AC              ;===========================================
1739 C8AC
1740 C8AC              startFont PROC 
1741 C8AC
1742 C8AC D4 30                 pei   <userID                  ;Pass application's user ID.
1743 C8AE A9 1B 00              lda   #27                      ;Pass pointer to direct page.
1744 C8B1 20 14 C7              jsr   pushDirectPage
1745 C8B4 A2 1B 02 22           _FMStartup 
1746 C8BB 60                    rts   
1747 C8BC                       ENDP 
1748 C8BC
1749 C8BC              ;===========================================
1750 C8BC              ;   Start Text Edit.
1751 C8BC              ;===========================================
1752 C8BC
1753 C8BC              startTextEdit PROC 
1754 C8BC
1755 C8BC                       IMPORT pushDirectPage 
1756 C8BC
1757 C8BC D4 30                 pei   <userID                  ;Pass application's user ID.
1758 C8BE A9 22 00              lda   #34                      ;Pass pointer to direct page.
1759 C8C1 20 14 C7              jsr   pushDirectPage
1760 C8C4 A2 22 02 22           _TEStartup 
1761 C8CB 60                    rts   
1762 C8CC                       ENDP 
1763 C8CC
1764 C8CC
1765 C8CC              ****************************************************************
1766 C8CC              *
1767 C8CC              * Central handle disposing routine.  Inputs handle in a & x
1768 C8CC              *
1769 C8CC              *
1770 C8CC              * Inputs:
1771 C8CC              *                   a-reg low word of handle
1772 C8CC              *                   x-reg high word of handle
1773 C8CC              *
1774 C8CC              * Outputs:
1775 C8CC              *                   a-reg error code
1776 C8CC              *                   carry error condition
1777 C8CC              *
1778 C8CC              * External Refs:
1779 C8CC              *                   none
1780 C8CC              *
1781 C8CC              * Entry Points:
1782 C8CC              *                   none
1783 C8CC              *
1784 C8CC                       longa on                       ; mode
1785 C8CC                       longi on
1786 C8CC              *
1787 C8CC              ****************************************************************
1788 C8CC
1789 C8CC              KillIt   PROC 
1790 C8CC DA                    phx   
1791 C8CD 48                    pha   
1792 C8CE A2 02 10 22           _DisposeHandle 
1793 C8D5 60                    rts   
1794 C8D6                       ENDP 
1795 C8D6
1796 C8D6
1797 C8D6                       END   
